/*
 * Avalon memory-mapped peripheral
 */

module mem_IO(input logic      clk,
	       input logic 	  		  reset,
	       input logic [15:0]    writedata,
	       input logic 	  		  write,
	       input logic		     chipselect,
	       input logic [7:0]  	  address,  // two bits needed for x,y coordinates
		
	       output logic [7:0] VGA_R, VGA_G, VGA_B,
	       output logic 	  VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n,
	       output logic 	  VGA_SYNC_n);

 
 typedef enum logic [11:0] {S0, S1} state_t;
 state_t state;
 
logic			 	start, done;
logic [15:0]   v1x, v1y, v1z;
logic [15:0]   v2x, v2y, v2z;
logic [15:0]   v3x, v3y, v3z;
logic [15:0]   pixel_color;
logic 			clear_screen;
logic 			hide_screen;

shader shader_inst(.*);

   always_ff @(posedge clk)
	  if (reset) begin 
			state <= S0;
			start <= 1;
		end
     else if (chipselect && write) begin
       case (address)
			
			/**** Total of 12  addresses to write to
			   0-8: vertices of face to draw
				9  : 2-bits representing 3 colors to draw. 0 represents black
			   10 : hide screen signal to hide the display
				11 : clear screen signal to clear the screen  *****/
			
			// vertices
			8'd0 : v1x <= writedata;
			8'd1 : v1y <= writedata;
			8'd2 : v1z <= writedata;
			8'd3 : v2x <= writedata;
			8'd4 : v2y <= writedata;
			8'd5 : v2z <= writedata;
			8'd6 : v3x <= writedata;
			8'd7 : v3y <= writedata;
			8'd8 : v3z <= writedata;
			
			// color
			8'd9 : pixel_color <= writedata;
			
			// hide and clear screen signals
			8'd10: begin
			
				if (writedata == 1) begin
					hide_screen <= 1;
				end
				else begin
					hide_screen <= 0;
				end
			end
			
			8'd11: begin
				
				if (writedata == 1) begin
					clear_screen <= 1;
				end
				
				else begin
					clear_screen <=0;
				end
				
				// after the last data item is sent start the shader operation
				state <= S0;
				start <= 1;
				
			end
			
       endcase
	 end	
	
	  else begin
			 case (state)
				S0: begin
					if (start) begin
						if (done) begin
							state <= S1;
						end
					end
				end
				
				S1: begin
					start <= 0;
					state <= S0; 
				end
			endcase
	  end
endmodule

